/*
 * Decompiled with CFR 0.152.
 */
import cern.jet.random.engine.MersenneTwister64;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Upgma {
    protected static MersenneTwister64 random = RandomUtil.getMersenneTwister64();
    protected static GenealogyAnalyzer ga = new GenealogyAnalyzer();
    protected static List<int[]> listOfJoints = new ArrayList<int[]>(100);
    protected static int currentSize = -1;
    protected static double[][] currentDistance = null;
    protected static double[][] spaceForDistance = null;

    protected static double[][] initialDistanceSpace(int n) {
        int n2 = n - 1;
        double[][] dArrayArray = new double[n2][];
        for (int i = 0; i < n2; ++i) {
            dArrayArray[i] = new double[i + 1];
        }
        return dArrayArray;
    }

    public static Genealogy tree(double[][] dArray) {
        return Upgma.tree(dArray, null);
    }

    public static Genealogy tree(double[][] dArray, String[] stringArray) {
        Object object;
        int n;
        int n2;
        currentSize = n2 = dArray.length + 1;
        currentDistance = Upgma.initialDistanceSpace(n2);
        spaceForDistance = Upgma.initialDistanceSpace(n2);
        for (int i = 0; i < currentSize - 1; ++i) {
            n = i + 1;
            object = dArray[i];
            double[] dArray2 = currentDistance[i];
            for (int j = 0; j < n; ++j) {
                dArray2[j] = (double)object[j];
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        for (n = 0; n < n2; ++n) {
            object = new DefaultNode();
            ((DefaultNode)object).setSize(1);
            if (stringArray == null) {
                ((DefaultNode)object).setName("Seq" + (n + 1));
            } else {
                ((DefaultNode)object).setName(stringArray[n]);
            }
            arrayList.add(object);
        }
        int[] nArray = new int[2];
        int n3 = n2;
        int n4 = n2 + 1;
        while (n3 > 1) {
            DefaultNode defaultNode = new DefaultNode();
            defaultNode.setName("Seq" + n4);
            double d = Upgma.getJoin(n3, currentDistance, nArray, arrayList);
            int n5 = nArray[0];
            int n6 = nArray[1];
            if (n5 > n6) {
                n5 = nArray[1];
                n6 = nArray[0];
            }
            Node node = (Node)arrayList.get(n5);
            Node node2 = (Node)arrayList.get(n6 + 1);
            defaultNode.addChild(node);
            defaultNode.addChild(node2);
            defaultNode.setSize(node.getSize() + node2.getSize());
            node.getBranch().setLength(d / 2.0 - ga.getTMRCA(node));
            node2.getBranch().setLength(d / 2.0 - ga.getTMRCA(node2));
            double d2 = node.getSize();
            double d3 = node2.getSize();
            double d4 = d2 / (d2 + d3);
            Upgma.recomputeDistance(currentSize, currentDistance, n5, n6, d4, listOfJoints);
            double[][] dArray3 = currentDistance;
            currentDistance = spaceForDistance;
            spaceForDistance = dArray3;
            --currentSize;
            arrayList.set(n5, defaultNode);
            arrayList.remove(n6 + 1);
            --n3;
            ++n4;
        }
        Node node = (Node)arrayList.get(0);
        DefaultGenealogy defaultGenealogy = new DefaultGenealogy();
        defaultGenealogy.setRoot(node);
        return defaultGenealogy;
    }

    protected static void recomputeDistance(int n, double[][] dArray, int n2, int n3, double d, List<int[]> list) {
        int n4 = n - 1;
        boolean bl = false;
        boolean bl2 = false;
        double d2 = Double.MAX_VALUE;
        list.clear();
        for (int i = 0; i < n4 - 1; ++i) {
            if (i == n2 - 1) {
                bl = true;
            } else if (i == n3) {
                bl2 = true;
            }
            int n5 = i + 1;
            double[] dArray2 = spaceForDistance[i];
            boolean bl3 = false;
            boolean bl4 = false;
            for (int j = 0; j < n5; ++j) {
                if (j == n2) {
                    bl3 = true;
                } else if (j == n3 + 1) {
                    bl4 = true;
                }
                double d3 = -1.7976931348623157E308;
                dArray2[j] = bl ? (d3 = d * dArray[n2 - 1][j] + (1.0 - d) * dArray[n3][j]) : (bl2 ? (bl3 ? (d3 = d * dArray[i + 1][n2] + (1.0 - d) * dArray[i + 1][n3 + 1]) : (!bl4 ? (d3 = dArray[i + 1][j]) : (d3 = dArray[i + 1][j + 1]))) : (bl3 ? (d3 = d * dArray[i][n2] + (1.0 - d) * dArray[n3][i + 1]) : (d3 = dArray[i][j])));
                bl3 = false;
                if (d3 < d2) {
                    d2 = d3;
                    list.clear();
                }
                if (d3 != d2) continue;
                int[] nArray = new int[]{j, i};
                list.add(nArray);
            }
            bl = false;
        }
    }

    public static double getJoin(int n, double[][] dArray, int[] nArray, List list) {
        int n2;
        int n3;
        int n4;
        double d = Double.MAX_VALUE;
        if (listOfJoints.isEmpty()) {
            n4 = n - 1;
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = n3 + 1;
                double[] dArray2 = dArray[n3];
                for (int i = 0; i < n2; ++i) {
                    double d2 = dArray2[i];
                    if (d2 < d) {
                        d = d2;
                        listOfJoints.clear();
                    }
                    if (d2 != d) continue;
                    int[] nArray2 = new int[]{i, n3};
                    listOfJoints.add(nArray2);
                }
            }
        } else {
            int[] nArray3 = listOfJoints.get(0);
            n3 = nArray3[0];
            n2 = nArray3[1];
            d = dArray[n2][n3];
        }
        n4 = listOfJoints.size();
        n3 = 0;
        if (n4 > 1) {
            n3 = (int)(random.nextDouble() * (double)n4);
        }
        int[] nArray4 = listOfJoints.get(n3);
        nArray[0] = nArray4[0];
        nArray[1] = nArray4[1];
        return d;
    }

    protected static void printDistanceMatrix(double[][] dArray, int n) {
        for (int i = 0; i < n - 1; ++i) {
            int n2 = i + 1;
            double[] dArray2 = dArray[i];
            for (int j = 0; j < n2; ++j) {
                double d = dArray2[j];
                System.out.print(d + " ");
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void main(String[] stringArray) {
        int n = 7;
        int n2 = n - 1;
        double[][] dArrayArray = new double[n2][];
        double[] dArray = new double[]{19.0};
        double[] dArray2 = new double[]{27.0, 31.0};
        double[] dArray3 = new double[]{8.0, 18.0, 26.0};
        double[] dArray4 = new double[]{33.0, 36.0, 41.0, 31.0};
        double[] dArray5 = new double[]{18.0, 1.0, 32.0, 17.0, 35.0};
        double[] dArray6 = new double[]{13.0, 13.0, 29.0, 14.0, 28.0, 12.0};
        dArrayArray[0] = dArray;
        dArrayArray[1] = dArray2;
        dArrayArray[2] = dArray3;
        dArrayArray[3] = dArray4;
        dArrayArray[4] = dArray5;
        dArrayArray[5] = dArray6;
        Upgma upgma = new Upgma();
        Node node = Upgma.tree(dArrayArray, null).getRoot();
        System.out.println();
    }
}

