/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;

public class TreeUtility {
    public static boolean debug = false;
    static ArrayList path = new ArrayList();

    public static void markSubtree(int n, Node node) {
        if (node == null) {
            return;
        }
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            TreeUtility.markSubtree(n, node.getChildAt(i));
        }
        node.setMark(n);
    }

    public static void rootAtMidPoint(Tree tree) {
        double d;
        int n;
        double d2 = 0.0;
        List list = tree.getLeafs();
        Node[] nodeArray = list.toArray(new Node[list.size()]);
        Node node = null;
        Node node2 = null;
        for (int i = 0; i < nodeArray.length - 1; ++i) {
            for (n = i + 1; n < nodeArray.length; ++n) {
                d = TreeUtility.distanceFromTree(nodeArray[i], nodeArray[n]);
                if (!(d > d2)) continue;
                node = nodeArray[i];
                node2 = nodeArray[n];
                d2 = d;
            }
        }
        Node node3 = TreeUtility.MRCA(node, node2);
        for (n = 0; n < 2; ++n) {
            d = 0.0;
            Node node4 = node;
            if (n == 1) {
                node4 = node2;
            }
            do {
                double d3;
                if (d + (d3 = Math.max(0.0, node4.getBranch().getLength())) >= d2 / 2.0) {
                    if (debug) {
                        System.out.println("The root is at branch between nodes " + node4.getName() + " " + node4.getParent().getName() + " bl=" + node4.getBranch().getLength() + "\n" + "distance to node " + node4.getName() + " is " + (d2 / 2.0 - d));
                    }
                    break;
                }
                d += d3;
            } while ((node4 = node4.getParent()) != node3);
            if (node4 == node3) continue;
            TreeUtility.setRootAt(tree, node4, d2 / 2.0 - d);
            return;
        }
    }

    static Node MRCA(Node node, Node node2) {
        Node node3;
        Node node4 = node;
        while (!TreeUtility.inThePath(node2, node3 = node4.getParent())) {
            node4 = node3;
        }
        return node3;
    }

    public static double distanceFromTree(Node node, Node node2) {
        Node node3 = TreeUtility.MRCA(node, node2);
        double d = TreeUtility.upToAncestor(node, node3);
        double d2 = TreeUtility.upToAncestor(node2, node3);
        return d + d2;
    }

    static double upToAncestor(Node node, Node node2) {
        double d = Math.max(0.0, node.getBranch().getLength());
        Node node3 = node;
        while ((node3 = node3.getParent()) != node2) {
            d += Math.max(0.0, node3.getBranch().getLength());
        }
        return d;
    }

    static boolean inThePath(Node node, Node node2) {
        Node node3 = node;
        if (node3 == null) {
            return false;
        }
        do {
            if (node3.getParent() != node2) continue;
            return true;
        } while ((node3 = node3.getParent()) != null && node3 != node3.getParent());
        return false;
    }

    public static void setRootAt(Tree tree, Node node, double d) {
        Node node2;
        ArrayList arrayList = TreeUtility.getPath(tree, node);
        int n = arrayList.size();
        if (n < 2) {
            return;
        }
        Node node3 = node.getParent();
        Node node4 = tree.getRoot();
        Node node5 = (Node)arrayList.get(n - 1);
        for (int i = n - 2; i >= 0; --i) {
            node2 = (Node)arrayList.get(i);
            node5.removeChild(node2);
            node2.addChild(node5);
            node5.getBranch().setLength(node2.getBranch().getLength());
            node5 = node2;
        }
        DefaultNode defaultNode = new DefaultNode();
        defaultNode.addChild(node);
        node.removeChild(node3);
        defaultNode.addChild(node3);
        node.getBranch().setLength(d);
        node3.getBranch().setLength(node3.getBranch().getLength() - d);
        if (node4.getChildCount() == 1) {
            node2 = node4.removeChild(0);
            node2.getBranch().setLength(node2.getBranch().getLength() + node4.getBranch().getLength());
            node4.getParent().addChild(node2);
            node4.removeAllParent();
        }
        tree.setRoot(defaultNode);
    }

    static ArrayList getPath(Tree tree, Node node) {
        path.clear();
        for (Node node2 = node; node2 != tree.getRoot(); node2 = node2.getParent()) {
            path.add(node2);
        }
        path.add(tree.getRoot());
        return path;
    }
}

