/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class Sequence
implements DNASequence,
Cloneable,
Comparable,
Serializable {
    protected String name;
    protected StringBuffer seq;
    protected int count = 1;
    protected boolean isIndividual = false;
    protected boolean knownHaplotype = false;

    public Sequence() {
    }

    public Sequence(String string) {
        this.setName(string);
    }

    public Sequence(String string, String string2) {
        this.setName(string);
        this.setSequence(string2);
    }

    public Sequence(String string, StringBuffer stringBuffer) {
        this.setName(string);
        this.setSequence(stringBuffer);
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setSequence(String string) {
        this.seq = new StringBuffer(string);
    }

    public void setSequence(StringBuffer stringBuffer) {
        this.seq = new StringBuffer(stringBuffer.toString());
    }

    public void isIndividual(boolean bl) {
        this.isIndividual = bl;
    }

    public boolean isIndividual() {
        return this.isIndividual;
    }

    public void setCount(int n) {
        this.count = n;
    }

    public void oneMore() {
        ++this.count;
    }

    public int getCount() {
        return this.count;
    }

    public void appendSeq(String string) {
        this.seq.append(this.seq);
    }

    public String getSequence() {
        return this.seq.toString();
    }

    public String getName() {
        return this.name;
    }

    public int getLength() {
        return this.seq.length();
    }

    public int length() {
        return this.seq.length();
    }

    public char getNucleotideAt(int n) {
        return this.seq.charAt(n);
    }

    public void setNucleotideAt(int n, char c) {
        this.seq.setCharAt(n, c);
    }

    public void print() {
        System.out.println(" Ind=" + this.isIndividual() + " Count=" + this.getCount() + "\n" + this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName() + " " + this.getLength() + " count=" + this.getCount() + "\n");
        int n = this.getLength();
        for (int i = 0; i < n; i += 80) {
            stringBuffer.append(this.seq.substring(i, i + 80 > this.seq.length() ? this.seq.length() : i + 80));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.getSequence().hashCode();
    }

    public boolean equals(Object object) {
        return this.getSequence().equals(((Sequence)object).getSequence());
    }

    public int compareTo(Object object) {
        return this.getSequence().compareTo(((Sequence)object).getSequence());
    }

    public static double difference(Sequence sequence, Sequence sequence2) {
        return Sequence.difference(sequence.getSequence(), sequence2.getSequence());
    }

    public static double difference(String string, String string2) {
        if (string == null || string2 == null) {
            return 0.0;
        }
        double d = 0.0;
        String string3 = string.toLowerCase();
        String string4 = string2.toLowerCase();
        int n = string3.length();
        for (int i = 0; i < n; ++i) {
            char c = string3.charAt(i);
            char c2 = string4.charAt(i);
            if (c == 'n' || c2 == 'n' || c == '-' || c2 == '-' || c == 'x' || c2 == 'x') continue;
            if (Nucleotide.isAmbiguous(c) || Nucleotide.isAmbiguous(c2)) {
                char[] cArray = Nucleotide.unpack(c);
                char[] cArray2 = Nucleotide.unpack(c2);
                double d2 = 0.0;
                for (int j = 0; j < 2; ++j) {
                    for (int k = 0; k < 2; ++k) {
                        d2 += cArray[j] == cArray2[k] ? 0.0 : 1.0;
                    }
                }
                d += d2 / 4.0;
                continue;
            }
            d += string3.charAt(i) == string4.charAt(i) ? 0.0 : 1.0;
        }
        return d;
    }

    public static boolean hasAmbiguity(String string) {
        for (int i = string.length(); i >= 0; --i) {
            char[] cArray = Nucleotide.unpack(string.charAt(i));
            if (cArray[0] != 'n' && cArray[1] != 'n' && cArray[0] == cArray[1]) continue;
            return true;
        }
        return false;
    }

    public void change(int n, int n2) {
        if (n > n2) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i <= n2; ++i) {
            stringBuffer.append('1');
        }
        this.seq = this.seq.replace(n, n2, stringBuffer.toString());
    }

    public Object clone() {
        try {
            Sequence sequence = (Sequence)super.clone();
            sequence.setSequence(this.getSequence());
            return sequence;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public boolean isHaplotypeKnown() {
        return this.knownHaplotype;
    }

    public void isHaplotypeKnown(boolean bl) {
        this.knownHaplotype = bl;
    }

    public static String pack(Sequence sequence, Sequence sequence2) {
        return Sequence.pack(sequence.getSequence(), sequence2.getSequence());
    }

    public static String pack(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            char c2 = string2.charAt(i);
            stringBuffer.append(Nucleotide.pack(c, c2));
        }
        return stringBuffer.toString();
    }

    public String getSequence(int n) {
        char[] cArray = new char[this.getLength()];
        for (int i = 0; i < this.getLength(); ++i) {
            char c = this.getNucleotideAt(i);
            cArray[i] = Nucleotide.unpack(c)[n - 1];
        }
        return new String(cArray);
    }

    public double difference() {
        return Sequence.difference(this.getSequence(1), this.getSequence(2));
    }

    public void delete(int n, int n2) {
        this.seq.delete(n, n2);
    }

    public void insert(int n, String string) {
        this.seq.insert(n, string);
    }

    public String getSegment(int n, int n2) {
        return this.seq.substring(n, n2);
    }
}

