/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitialTablesForSubtreeProperties
extends D_Distribution {
    public final int maxSampleSize = 10000;
    public static final int SEQUENCE_PHYLIP = 1;
    public static final int SEQUENCE_MEGA = 2;
    public static final int SEQUENCE_ARLEQUIN = 3;
    public static final int SEQUENCE_NEXUS = 4;
    protected int dataType = -1;
    protected String tableFileName = "";
    protected String directory = "";
    protected Properties properties;
    protected String outgroupKeyword = "outgroup";

    public void establishTables(int n) {
        this.clear();
        this.readPreEstablishedTables();
        if (!this.preTableReady_VarL_majors[n - 1]) {
            Object object;
            int n2 = InitialTablesForSubtreeProperties.maxX(this.n);
            this.preStoredExpL_majors[n - 1] = this.calculateExpectedL_major(this.n, n);
            this.preTableReady_ExpL_majors[n - 1] = true;
            this.preStoredExpL_minors[n - 1] = this.calculateExpectedL_minor(this.n, n);
            this.preTableReady_ExpL_minors[n - 1] = true;
            double d = this.logFactorial(this.n - 2) - this.logFactorial(n - 1) - this.logFactorial(this.n - n - 1);
            double d2 = Math.log((double)numOfIterations * 5.0);
            System.out.println("Establishing the table....");
            if (d2 > d) {
                this.preStoredVarL_majors[n - 1] = this.calculateVarL_major(this.n, n);
                this.preTableReady_VarL_majors[n - 1] = true;
                this.preStoredVarL_minors[n - 1] = this.calculateVarL_minor(this.n, n);
                this.preTableReady_VarL_minors[n - 1] = true;
            } else {
                object = this.calculateVarLs_MonteCarlo(this.n, n);
                this.preStoredVarL_majors[n - 1] = object[1];
                this.preTableReady_VarL_majors[n - 1] = true;
                this.preStoredVarL_minors[n - 1] = object[0];
                this.preTableReady_VarL_minors[n - 1] = true;
            }
            object = this.n + " " + n + " " + this.preStoredExpL_majors[n - 1] + " " + this.preStoredExpL_minors[n - 1] + " " + this.preStoredVarL_majors[n - 1] + " " + this.preStoredVarL_minors[n - 1] + nl;
            try {
                File file = new File(this.directory);
                File file2 = new File(file, this.tableFileName);
                FileOutputStream fileOutputStream = new FileOutputStream(file2, true);
                fileOutputStream.write(((String)object).getBytes());
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("Error! " + iOException.getMessage());
                System.out.println("Exit...");
                System.exit(0);
            }
        }
    }

    protected void loadProperties() {
        this.properties = new Properties();
        try {
            URL uRL = this.getClass().getClassLoader().getResource("properties.txt");
            InputStream inputStream = uRL.openConnection().getInputStream();
            this.properties.load(inputStream);
            inputStream.close();
            this.directory = (String)this.properties.get("directory");
            this.tableFileName = (String)this.properties.get("preCalculatedTable");
        }
        catch (Exception exception) {
            System.out.println("Error! " + exception.getMessage());
            exception.printStackTrace();
            System.out.println("Exit...");
            System.exit(0);
        }
    }

    protected void readPreEstablishedTables() {
        this.readPreEstablishedTables(this.n);
    }

    protected void readPreEstablishedTables(int n) {
        this.clear();
        try {
            File file = new File(this.directory);
            File file2 = new File(file, this.tableFileName);
            String string = file2.getAbsolutePath();
            List list = ReadTextFile.readLineToLine(string);
            for (int i = 0; i < list.size(); ++i) {
                String string2 = (String)list.get(i);
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                double d = Double.parseDouble(stringTokenizer.nextToken());
                double d2 = Double.parseDouble(stringTokenizer.nextToken());
                double d3 = Double.parseDouble(stringTokenizer.nextToken());
                double d4 = Double.parseDouble(stringTokenizer.nextToken());
                if (n2 != n || n3 - 1 >= this.preStoredExpL_majors.length) continue;
                this.preStoredExpL_majors[n3 - 1] = d;
                this.preStoredExpL_minors[n3 - 1] = d2;
                this.preStoredVarL_majors[n3 - 1] = d3;
                this.preStoredVarL_minors[n3 - 1] = d4;
                this.preTableReady_ExpL_majors[n3 - 1] = true;
                this.preTableReady_ExpL_minors[n3 - 1] = true;
                this.preTableReady_VarL_majors[n3 - 1] = true;
                this.preTableReady_VarL_minors[n3 - 1] = true;
            }
        }
        catch (Exception exception) {
            System.out.println(this.tableFileName + " is not available. A new file will be created!");
        }
    }

    public boolean isThereOutgroup(List<Haplotype> list) {
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            Haplotype haplotype = list.get(i);
            if (!haplotype.name.equalsIgnoreCase(this.outgroupKeyword)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected List<Haplotype> autoDetectFormat(String string) throws IOException {
        Cloneable cloneable;
        int n;
        Object[] objectArray = new Object[]{new ReadArlequin(), new ReadMega(), new ReadPhylip(), new ReadNexus()};
        List list = null;
        for (n = 0; n < objectArray.length; ++n) {
            try {
                cloneable = (ReadSeqFile)objectArray[n];
                list = cloneable.readSeq(string);
                if (cloneable instanceof ReadArlequin) {
                    this.dataType = 3;
                }
                if (cloneable instanceof ReadMega) {
                    this.dataType = 2;
                }
                if (cloneable instanceof ReadPhylip) {
                    this.dataType = 1;
                }
                if (cloneable instanceof ReadNexus) {
                    this.dataType = 4;
                }
                if (list == null || list.isEmpty()) continue;
                break;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (list == null) {
            throw new IOException("Unsupported data format! The current version only supports four formats: ARLEQUIN, MEGA, PHYLIP and NEXUS!");
        }
        for (n = 0; n < list.size(); ++n) {
            cloneable = (Haplotype)list.get(n);
            if (((Haplotype)cloneable).count != 0) continue;
            list.remove(n);
            --n;
        }
        n = list.size();
        for (int i = 0; i < n; ++i) {
            Haplotype haplotype = (Haplotype)list.get(i);
            if (haplotype.count <= 1) continue;
            for (int j = 0; j < haplotype.count - 1; ++j) {
                Haplotype haplotype2 = new Haplotype(haplotype.getSeq(), haplotype.getName() + "_" + (j + 1));
                haplotype2.setCount(1);
                list.add(haplotype2);
            }
            haplotype.setName(haplotype.getName() + "_0");
            haplotype.setCount(1);
        }
        return list;
    }

    public static void main(String[] stringArray) {
        block16: {
            InitialTablesForSubtreeProperties initialTablesForSubtreeProperties = new InitialTablesForSubtreeProperties();
            initialTablesForSubtreeProperties.loadProperties();
            try {
                boolean bl = true;
                if (stringArray.length == 1) {
                    try {
                        int n;
                        initialTablesForSubtreeProperties.n = n = Integer.parseInt(stringArray[0]);
                        int n2 = InitialTablesForSubtreeProperties.maxX(n);
                        for (int i = 1; i <= n2; ++i) {
                            initialTablesForSubtreeProperties.establishTables(i);
                        }
                        System.out.println("Finished...");
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                    if (!bl) {
                        try {
                            int n;
                            String string = stringArray[0];
                            File file = new File(initialTablesForSubtreeProperties.directory);
                            File file2 = new File(file, string);
                            String string2 = file2.getAbsolutePath();
                            List<Haplotype> list = initialTablesForSubtreeProperties.autoDetectFormat(string2);
                            for (n = 0; n < list.size(); ++n) {
                                System.out.println(list.get(n));
                            }
                            n = list.size();
                            if (initialTablesForSubtreeProperties.isThereOutgroup(list)) {
                                --n;
                            }
                            int n3 = InitialTablesForSubtreeProperties.maxX(n);
                            initialTablesForSubtreeProperties.n = n;
                            for (int i = 1; i <= n3; ++i) {
                                System.out.println("n = " + n + " x = " + i);
                                initialTablesForSubtreeProperties.establishTables(i);
                            }
                            System.out.println("Finished...");
                        }
                        catch (IOException iOException) {
                            System.out.println("Error! " + iOException.getMessage());
                            iOException.printStackTrace();
                            System.out.println("Exit...");
                        }
                    }
                    break block16;
                }
                if (stringArray.length == 2) {
                    try {
                        int n = Integer.parseInt(stringArray[0]);
                        int n4 = Integer.parseInt(stringArray[1]);
                        initialTablesForSubtreeProperties.n = n;
                        initialTablesForSubtreeProperties.establishTables(n4);
                        System.out.println("Finished...");
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                } else {
                    System.out.println("initialTable n");
                    System.out.println("initialTable dataFileName");
                    System.out.println("initialTable n x");
                }
            }
            catch (Exception exception) {
                System.out.println("Error! " + exception.getMessage());
                exception.printStackTrace();
                System.out.println("Exit...");
            }
        }
    }
}

