/*
 * Decompiled with CFR 0.152.
 */
import cern.jet.random.engine.MersenneTwister64;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class GenealogyAnalyzer
implements Serializable,
Cloneable {
    public static int INITIAL_MAX_SAMPLE_SIZE = 1000;
    public static final int INITIAL_SIZE = 0;
    public static final int X_SIZE = -2;
    protected Node root;
    protected List branchs;
    protected List leafs;
    protected boolean branchLengthsUpdated = false;
    protected double[] branchLengths = new double[INITIAL_MAX_SAMPLE_SIZE];
    public MersenneTwister64 random = RandomUtil.getMersenneTwister64();

    public GenealogyAnalyzer() {
        this.branchs = new ArrayList(INITIAL_MAX_SAMPLE_SIZE * 2);
        this.leafs = new ArrayList(INITIAL_MAX_SAMPLE_SIZE);
    }

    public GenealogyAnalyzer(Node node) {
        this();
        this.setGenealogy(node);
    }

    protected double an(int n) {
        double d = 0.0;
        for (int i = 1; i < n; ++i) {
            d += 1.0 / (double)i;
        }
        return d;
    }

    protected void clear() {
        this.branchs.clear();
        this.leafs.clear();
    }

    protected void clearBranchLengths() {
        int n = this.branchLengths.length;
        for (int i = 0; i < n; ++i) {
            this.branchLengths[i] = 0.0;
        }
        this.branchLengthsUpdated = false;
    }

    public Node copyTheTree() {
        Node node = this.root.getClone();
        this.copyTheNode(node, this.root);
        return node;
    }

    protected void copyTheNode(Node node, Node node2) {
        for (int i = 0; i < node2.getChildCount(); ++i) {
            Node node3 = node2.getChildAt(i);
            Node node4 = node3.getClone();
            node.addChild(node4);
            this.copyTheNode(node4, node3);
        }
    }

    public List getBranchsWithSize(int n) {
        this.branchs.clear();
        this.getBranchsWithSize(this.getRoot(), this.branchs, n);
        return this.branchs;
    }

    protected void getBranchsWithSize(Node node, List list, int n) {
        int n2 = node.getSize();
        if (n2 == n) {
            list.add(node);
        } else if (n == -1 && node != this.getRoot()) {
            list.add(node);
        } else if (n == -2 && node != this.getRoot() && n2 > 2) {
            list.add(node);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.getBranchsWithSize(node.getChildAt(i), list, n);
        }
    }

    protected void getLeavesOfTree(Node node, List list) {
        int n = node.getChildCount();
        if (n == 0) {
            list.add(node);
        }
        for (int i = 0; i < n; ++i) {
            this.getLeavesOfTree(node.getChildAt(i), list);
        }
    }

    public List getLeaves() {
        this.leafs.clear();
        this.getLeavesOfTree(this.getRoot(), this.leafs);
        return this.leafs;
    }

    public List getLeavesOfDescendants(Node node) {
        this.leafs.clear();
        this.getLeavesOfTree(node, this.leafs);
        return this.leafs;
    }

    public double getLengthOfBranchs(int n) {
        if (!this.branchLengthsUpdated) {
            this.initialBranchLengths(this.root.getSize());
            this.updateBranchLength();
            this.branchLengthsUpdated = true;
        }
        if (n <= 0) {
            return this.branchLengths[0];
        }
        return this.branchLengths[n];
    }

    public double getLengthOfTree() {
        return this.getLengthOfBranchs(-1);
    }

    public int getNumOfMutations() {
        return this.getNumOfMutations(-1);
    }

    public int getNumOfMutations(int n) {
        return this.getNumOfMutations(this.getRoot(), n);
    }

    public int getNumOfMutations(Node node, int n) {
        int n2 = 0;
        int n3 = node.getChildCount();
        if (n3 != 0) {
            for (int i = 0; i < n3; ++i) {
                Node node2 = node.getChildAt(i);
                int n4 = node2.getSize();
                if (n4 == n || n == -1) {
                    n2 += node2.getBranch().getMutation();
                }
                n2 += this.getNumOfMutations(node2, n);
            }
        }
        return n2;
    }

    public double getTheta() {
        int n = this.getSampleSize();
        int n2 = this.getNumOfMutations();
        double d = (double)n2 / this.an(n);
        return d;
    }

    public double getTMRCA() {
        if (this.root.getChildCount() == 0) {
            return 0.0;
        }
        Node node = this.root.getChildAt(0);
        double d = node.getBranch().getLength() + this.getTMRCA(node);
        return d;
    }

    public double getTMRCA(Node node) {
        double d = 0.0;
        if (node.getChildCount() != 0) {
            Node node2 = node.getChildAt(0);
            d = node2.getBranch().getLength() + this.getTMRCA(node2);
        }
        return d;
    }

    public List getNodesWithSize(int n) {
        return this.getBranchsWithSize(n);
    }

    public List getNodes() {
        return this.getBranchsWithSize(-1);
    }

    public double getPi() {
        double d = 0.0;
        int n = this.getSampleSize();
        for (int i = 1; i < n; ++i) {
            d += (double)((n - i) * i * this.getNumOfMutations(i));
        }
        d = d * 2.0 / (double)(n * (n - 1));
        return d;
    }

    public Node getRoot() {
        return this.root;
    }

    public int getSampleSize() {
        return this.root.getSize();
    }

    public void initialSize() {
        this.initialSize(this.getRoot());
    }

    protected void initialSize(Node node) {
        if (node.getChildCount() == 0) {
            node.setSize(1);
        } else {
            int n = 0;
            for (int i = 0; i < node.getChildCount(); ++i) {
                Node node2 = node.getChildAt(i);
                this.initialSize(node2);
                n += node2.getSize();
            }
            node.setSize(n);
        }
    }

    public void initialBranchLengths(int n) {
        if (n > INITIAL_MAX_SAMPLE_SIZE) {
            INITIAL_MAX_SAMPLE_SIZE = n;
            this.branchLengths = new double[n];
        }
    }

    public void setGenealogy(Node node) {
        this.setGenealogy(node, false);
    }

    public void setGenealogy(Node node, boolean bl) {
        this.root = node;
        this.clear();
        if (bl) {
            this.initialSize();
        }
        this.branchLengthsUpdated = false;
    }

    protected void updateBranchLength() {
        this.clearBranchLengths();
        Node node = this.getRoot();
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.updateBranchLength(node.getChildAt(i));
        }
        this.branchLengthsUpdated = true;
    }

    protected void updateBranchLength(Node node) {
        int n = node.getSize();
        if (n < this.getSampleSize()) {
            double d = node.getBranch().getLength();
            int n2 = n;
            this.branchLengths[n2] = this.branchLengths[n2] + d;
            this.branchLengths[0] = this.branchLengths[0] + d;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.updateBranchLength(node.getChildAt(i));
        }
    }
}

