/*
 * Decompiled with CFR 0.152.
 */
import cern.jet.random.engine.MersenneTwister64;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.List;

public class D_Distribution {
    public static final int maxSampleSize = 10000;
    public static final double maxX_percentage = DuTest.maxX_percentage;
    public static int numOfIterations = 1000000;
    protected int n = 100;
    protected final boolean establishedTable = true;
    protected GenealogyAnalyzer ga = new GenealogyAnalyzer();
    protected DecimalFormat decimal = new DecimalFormat("#.#####");
    protected double[] logFactorial;
    protected StringBuffer[] sbs = new StringBuffer[10000];
    protected static char[] lineBreak = new char[]{'\r', '\n'};
    protected static String nl = new String(lineBreak);
    protected boolean preTableReady = false;
    protected boolean[] preTableReady_VarL_majors;
    protected boolean[] preTableReady_VarL_minors;
    protected boolean[] preTableReady_ExpL_majors;
    protected boolean[] preTableReady_ExpL_minors;
    protected double[] preStoredVarL_majors;
    protected double[] preStoredVarL_minors;
    protected double[] preStoredExpL_majors;
    protected double[] preStoredExpL_minors;
    protected DecimalFormat threeDecimal = new DecimalFormat("#.###");
    protected MersenneTwister64 random;

    public D_Distribution() {
        int n;
        this.logFactorial = new double[10000];
        for (n = 0; n < this.logFactorial.length; ++n) {
            this.logFactorial[n] = n <= 140 ? Math.log(Factorial.doubleValue(n)) : Factorial.gosperLog(n);
        }
        this.random = new MersenneTwister64(Calendar.getInstance().getTime());
        n = D_Distribution.maxX(10000);
        this.preTableReady_VarL_majors = new boolean[n];
        this.preTableReady_VarL_minors = new boolean[n];
        this.preTableReady_ExpL_majors = new boolean[n];
        this.preTableReady_ExpL_minors = new boolean[n];
        this.preStoredVarL_majors = new double[n];
        this.preStoredVarL_minors = new double[n];
        this.preStoredExpL_majors = new double[n];
        this.preStoredExpL_minors = new double[n];
    }

    public static int maxX(int n) {
        int n2 = (int)(maxX_percentage * (double)(n - 1) / 2.0);
        n2 = n2 == 0 ? 1 : n2;
        return n2;
    }

    public void clear() {
        int n = D_Distribution.maxX(10000);
        this.preTableReady_VarL_majors = new boolean[n];
        this.preTableReady_VarL_minors = new boolean[n];
        this.preTableReady_ExpL_majors = new boolean[n];
        this.preTableReady_ExpL_minors = new boolean[n];
    }

    protected double getTMRCA(Node node) {
        double d = 0.0;
        int n = node.getChildCount();
        if (n != 0) {
            Node node2 = node.getChildAt(0);
            d = node2.getBranch().getLength() + this.getTMRCA(node2);
        }
        return d;
    }

    protected double cuvDepthOfNodes(Node node) {
        int n = node.getChildCount();
        double d = this.getTMRCA(node);
        for (int i = 0; i < n; ++i) {
            Node node2 = node.getChildAt(i);
            d += this.cuvDepthOfNodes(node2);
        }
        return d;
    }

    protected double avgDepthOfNodes(Node node) {
        double d = this.cuvDepthOfNodes(node);
        int n = node.getSize();
        if (n > 1) {
            d /= (double)(n - 1);
        }
        return d;
    }

    public double median(double[] dArray) {
        int n = dArray.length;
        QSort.sort(dArray);
        int n2 = n / 2;
        double d = dArray[n / 2];
        if (n % 2 == 0) {
            d = dArray[n / 2 - 1];
        }
        return d;
    }

    public double quantileDepthOfNodes(Node node, double d) {
        int n = node.getSize() - 1;
        double[] dArray = new double[n];
        int[] nArray = new int[1];
        this.getDepthOfNodes(node, nArray, dArray);
        int n2 = dArray.length;
        QSort.sort(dArray);
        int n3 = (int)((double)n2 * d);
        return dArray[n3];
    }

    public double medianDepthOfNodes(Node node) {
        int n = node.getSize() - 1;
        double[] dArray = new double[n];
        int[] nArray = new int[1];
        this.getDepthOfNodes(node, nArray, dArray);
        double d = this.median(dArray);
        return d;
    }

    protected void getDepthOfNodes(Node node, int[] nArray, double[] dArray) {
        int n = node.getChildCount();
        if (n > 0) {
            double d;
            dArray[nArray[0]] = d = this.getTMRCA(node);
            for (int i = 0; i < n; ++i) {
                Node node2 = node.getChildAt(i);
                nArray[0] = nArray[0] + 1;
                this.getDepthOfNodes(node2, nArray, dArray);
            }
        } else {
            nArray[0] = nArray[0] - 1;
        }
    }

    public double getExpL_major(int n, int n2) {
        if (!this.preTableReady_ExpL_majors[n2 - 1]) {
            this.preStoredExpL_majors[n2 - 1] = this.calculateExpectedL_major(n, n2);
            this.preTableReady_ExpL_majors[n2 - 1] = true;
        }
        return this.preStoredExpL_majors[n2 - 1];
    }

    public double getExpL_minor(int n, int n2) {
        if (!this.preTableReady_ExpL_minors[n2 - 1]) {
            this.preStoredExpL_minors[n2 - 1] = this.calculateExpectedL_minor(n, n2);
            this.preTableReady_ExpL_minors[n2 - 1] = true;
        }
        return this.preStoredExpL_minors[n2 - 1];
    }

    public double getVarL_major(int n, int n2) {
        if (!this.preTableReady_VarL_majors[n2 - 1]) {
            this.preStoredVarL_majors[n2 - 1] = this.calculateVarL_major(n, n2);
            this.preTableReady_VarL_majors[n2 - 1] = true;
        }
        return this.preStoredVarL_majors[n2 - 1];
    }

    public double getVarL_minor(int n, int n2) {
        if (!this.preTableReady_VarL_minors[n2 - 1]) {
            this.preStoredVarL_minors[n2 - 1] = this.calculateVarL_minor(n, n2);
            this.preTableReady_VarL_minors[n2 - 1] = true;
        }
        return this.preStoredVarL_minors[n2 - 1];
    }

    protected double an(int n) {
        double d = 0.0;
        for (int i = 1; i < n; ++i) {
            d += 1.0 / (double)i;
        }
        return d;
    }

    protected double a2(int n) {
        double d = 0.0;
        for (int i = 1; i < n; ++i) {
            d += 1.0 / ((double)i * (double)i);
        }
        return d;
    }

    protected double[][] buildDistanceMatrix(String[] stringArray) {
        int n;
        int n2 = stringArray.length;
        int n3 = n2 - 1;
        double[][] dArrayArray = new double[n3][];
        for (n = 0; n < n3; ++n) {
            dArrayArray[n] = new double[n + 1];
        }
        for (n = 1; n < n2; ++n) {
            String string = stringArray[n];
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                dArrayArray[n - 1][i] = this.numOfNucDiff(string, string2);
            }
        }
        return dArrayArray;
    }

    public double calculateCovTheta_minor_major(int n, int n2, double d, double d2) {
        double d3 = this.getExpL_minor(n, n2);
        double d4 = this.getExpL_major(n, n2);
        double d5 = this.calculateExpected_Lmajor_Lminor(n, n2);
        double d6 = d2 * (d5 / (d4 * d3) - 1.0);
        return d6;
    }

    public double calculateVarTheta_major(int n, int n2, double d, double d2) {
        double d3 = this.getExpL_major(n, n2);
        double d4 = this.getVarL_major(n, n2);
        double d5 = d3 * d / 2.0 + d4 * d2 / 4.0;
        double d6 = 4.0 * d5 / (d3 * d3);
        return d6;
    }

    public double calculateVarTheta_minor(int n, int n2, double d, double d2) {
        double d3 = this.getExpL_minor(n, n2);
        double d4 = this.getVarL_minor(n, n2);
        double d5 = d3 * d / 2.0 + d4 * d2 / 4.0;
        double d6 = 4.0 * d5 / (d3 * d3);
        return d6;
    }

    public double calculateExpectedL_major(int n, int n2) {
        double d = 0.0;
        for (int i = 3; i <= n; ++i) {
            d += 2.0 * this.Dk_dividedBy_nT(n, n2, i) / ((double)i * (double)(i - 1));
        }
        return d;
    }

    public double calculateExpectedL_minor(int n, int n2) {
        double d = 0.0;
        for (int i = 2; i <= n; ++i) {
            d += 2.0 / (double)(i - 1);
        }
        return d -= this.getExpL_major(n, n2);
    }

    public double calculateExpected_Lmajor_Lminor(int n, int n2) {
        double d = this.getExpL_major(n, n2);
        double d2 = this.getExpL_minor(n, n2);
        double d3 = this.getVarL_major(n, n2);
        double d4 = this.getVarL_minor(n, n2);
        double d5 = 0.0;
        for (double d6 = 2.0; d6 <= (double)n; d6 += 1.0) {
            d5 += 2.0 / ((d6 - 1.0) * (d6 - 1.0));
        }
        d5 = d5 - (d3 + d4) / 2.0 + d * d2;
        return d5;
    }

    public double calculateVarL_major(int n, int n2) {
        int[] nArray = new int[n + 1];
        nArray[1] = 2;
        nArray[n - n2 + 1] = n + 1;
        int n3 = 2;
        double d = this.getExpL_major(n, n2);
        double d2 = this.calculateVarL_major(n, n2, nArray, n3) / this.nT(n, n2);
        return d2 -= d * d;
    }

    public double[] calculateVarLs_MonteCarlo(int n, int n2) {
        int[] nArray = new int[n + 1];
        int n3 = n - 2;
        boolean[] blArray = new boolean[n3];
        long l = System.currentTimeMillis();
        int n4 = 10;
        int n5 = numOfIterations / n4;
        double[] dArray = new double[2];
        for (int i = 0; i < numOfIterations; ++i) {
            double d;
            int n6;
            double d2;
            int n7;
            int n8;
            for (n8 = 0; n8 < n3; ++n8) {
                blArray[n8] = false;
            }
            for (n8 = 0; n8 < n2 - 1; ++n8) {
                n7 = -1;
                while (blArray[n7 = (int)(this.random.nextDouble() * (double)n3)]) {
                }
                blArray[n7] = true;
            }
            nArray[1] = 2;
            nArray[n - n2 + 1] = n + 1;
            n8 = 1;
            for (n7 = 0; n7 < n3; ++n7) {
                if (blArray[n7]) continue;
                nArray[++n8] = n7 + 3;
            }
            for (n7 = 2; n7 <= n; ++n7) {
                d2 = this.get_bi_QuickVer(n, n2, nArray, n7);
                for (n6 = n7; n6 <= n; ++n6) {
                    d = this.get_bi_QuickVer(n, n2, nArray, n6);
                    dArray[0] = dArray[0] + 8.0 * d2 * d / ((double)n7 * (double)n6 * (double)(n7 - 1) * (double)(n6 - 1));
                }
            }
            for (n7 = nArray[2]; n7 <= n; ++n7) {
                d2 = this.get_ai_QuickVer(n, n2, nArray, n7);
                for (n6 = n7; n6 <= n; ++n6) {
                    d = this.get_ai_QuickVer(n, n2, nArray, n6);
                    dArray[1] = dArray[1] + 8.0 * d2 * d / ((double)n7 * (double)n6 * (double)(n7 - 1) * (double)(n6 - 1));
                }
            }
            if (i % n5 != 0 || i == 0) continue;
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            long l4 = l3 / (long)i * (long)numOfIterations - l3;
            System.out.println("For the calculating section of n=" + n + " x=" + n2 + ": Spent=" + l3 / 60000L + " mins, remaining=" + l4 / 3600000L + " hours.");
        }
        dArray[0] = dArray[0] / (double)numOfIterations;
        dArray[1] = dArray[1] / (double)numOfIterations;
        double d = this.getExpL_minor(n, n2);
        double d3 = this.getExpL_major(n, n2);
        dArray[0] = dArray[0] - d * d;
        dArray[1] = dArray[1] - d3 * d3;
        return dArray;
    }

    protected double calculateVarL_major(int n, int n2, int[] nArray, int n3) {
        double d = 0.0;
        if (n3 > n - n2) {
            for (int i = nArray[2]; i <= n; ++i) {
                for (int j = i; j <= n; ++j) {
                    double d2 = this.get_ai_QuickVer(n, n2, nArray, i);
                    double d3 = this.get_ai_QuickVer(n, n2, nArray, j);
                    d += 8.0 * d2 * d3 / ((double)i * (double)j * (double)(i - 1) * (double)(j - 1));
                }
            }
        } else {
            int n4 = nArray[n3 - 1] + 1;
            while (n4 <= n2 + n3) {
                nArray[n3] = n4++;
                d += this.calculateVarL_major(n, n2, nArray, n3 + 1);
            }
        }
        return d;
    }

    public double calculateVarL_minor(int n, int n2) {
        int[] nArray = new int[n + 1];
        nArray[1] = 2;
        nArray[n - n2 + 1] = n + 1;
        int n3 = 2;
        double d = this.getExpL_minor(n, n2);
        double d2 = this.calculateVarL_minor(n, n2, nArray, n3) / this.nT(n, n2);
        return d2 -= d * d;
    }

    protected double calculateVarL_minor(int n, int n2, int[] nArray, int n3) {
        double d = 0.0;
        if (n3 > n - n2) {
            for (int i = 2; i <= n; ++i) {
                for (int j = i; j <= n; ++j) {
                    double d2 = this.get_bi_QuickVer(n, n2, nArray, i);
                    double d3 = this.get_bi_QuickVer(n, n2, nArray, j);
                    d += 8.0 * d2 * d3 / ((double)i * (double)j * (double)(i - 1) * (double)(j - 1));
                }
            }
        } else {
            int n4 = nArray[n3 - 1] + 1;
            while (n4 <= n2 + n3) {
                nArray[n3] = n4++;
                d += this.calculateVarL_minor(n, n2, nArray, n3 + 1);
            }
        }
        return d;
    }

    protected double nT(int n, int n2) {
        double d = this.logFactorial(n - 2) - this.logFactorial(n2 - 1) - this.logFactorial(n - n2 - 1);
        d = Math.round(Math.exp(d));
        return d;
    }

    protected double Dk(int n, int n2, int n3) {
        double d = 0.0;
        double d2 = n3 - n2 - 1;
        for (int i = 3; i <= n2 + 2; ++i) {
            double d3 = n3 - i + 1;
            for (int j = 1; j <= n - n2 - 1; ++j) {
                if (!(d2 <= (double)j) || !((double)j <= d3)) continue;
                double d4 = this.logFactorial(n3 - i) - this.logFactorial(n3 - i - j + 1) - this.logFactorial(j - 1);
                d += (double)(Math.round(Math.exp(d4 += this.logFactorial(n - n3) - this.logFactorial(n2 + j + 1 - n3) - this.logFactorial(n - n2 - j - 1))) * (long)(j + 1));
            }
        }
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            System.out.println("dk = " + d + " x = " + n2 + " k = " + n3);
        }
        return d;
    }

    protected double Dk_dividedBy_nT(int n, int n2, int n3) {
        double d = this.logFactorial(n - 2) - this.logFactorial(n2 - 1) - this.logFactorial(n - n2 - 1);
        double d2 = this.nT(n, n2);
        double d3 = 0.0;
        double d4 = n3 - n2 - 1;
        for (int i = 3; i <= n2 + 2; ++i) {
            double d5 = n3 - i + 1;
            for (int j = 1; j <= n - n2 - 1; ++j) {
                if (!(d4 <= (double)j) || !((double)j <= d5)) continue;
                double d6 = this.logFactorial(n3 - i) - this.logFactorial(n3 - i - j + 1) - this.logFactorial(j - 1);
                d3 += Math.exp(d6 += this.logFactorial(n - n3) - this.logFactorial(n2 + j + 1 - n3) - this.logFactorial(n - n2 - j - 1) - d) * (double)(j + 1);
            }
        }
        return d3;
    }

    protected int[] getMinorIndex(Node node) {
        Node node2 = node.getChildAt(0);
        Node node3 = node.getChildAt(1);
        if (node3.getSize() < node2.getSize()) {
            node2 = node3;
        }
        List list = this.ga.getLeavesOfDescendants(node2);
        int[] nArray = new int[list.size()];
        for (int i = 0; i < nArray.length; ++i) {
            try {
                Node node4 = (Node)list.get(i);
                nArray[i] = Integer.parseInt(node4.getName()) - 1;
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error in getMinorIndex(Node root)! " + exception.getMessage());
                System.exit(0);
            }
        }
        return nArray;
    }

    protected int[] getMinorIndex(Node node, String[] stringArray) {
        Node node2 = node.getChildAt(0);
        Node node3 = node.getChildAt(1);
        if (node3.getSize() < node2.getSize()) {
            node2 = node3;
        }
        List list = this.ga.getLeavesOfDescendants(node2);
        int[] nArray = new int[list.size()];
        for (int i = 0; i < nArray.length; ++i) {
            try {
                Node node4 = (Node)list.get(i);
                nArray[i] = this.indexOf(stringArray, node4.getName());
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error in getMinorIndex(Node root)! " + exception.getMessage());
                System.exit(0);
            }
        }
        return nArray;
    }

    protected int getNumOfInterMuts(int n) {
        int n2 = 20;
        if (n > 40) {
            n2 = n;
        }
        return n2;
    }

    protected int[] getSegregatingSites(Node[] nodeArray, int n) {
        int[] nArray = new int[n - 1];
        for (int i = 0; i < nodeArray.length; ++i) {
            this.ga.setGenealogy(nodeArray[i]);
            for (int j = 1; j < n; ++j) {
                int n2 = j - 1;
                nArray[n2] = nArray[n2] + this.ga.getNumOfMutations(j);
            }
        }
        return nArray;
    }

    protected void getSequencesNoOutgoup(String[] stringArray, Node[] nodeArray) {
        int n;
        boolean[] blArray = new boolean[this.n];
        for (n = 0; n < this.n; ++n) {
            this.sbs[n] = new StringBuffer(10000);
        }
        for (n = 0; n < nodeArray.length; ++n) {
            this.ga.setGenealogy(nodeArray[n]);
            List list = this.ga.getNodes();
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                int n3;
                Node node = (Node)list.get(i);
                int n4 = node.getBranch().getMutation();
                if (n4 <= 0) continue;
                List list2 = this.ga.getLeavesOfDescendants(node);
                for (n3 = 0; n3 < this.n; ++n3) {
                    blArray[n3] = false;
                }
                for (n3 = 0; n3 < list2.size(); ++n3) {
                    Node node2 = (Node)list2.get(n3);
                    int n5 = node2.getNameID() - 1;
                    for (int j = 0; j < n4; ++j) {
                        this.sbs[n5].append("1");
                    }
                    blArray[n5] = true;
                }
                for (n3 = 0; n3 < this.n; ++n3) {
                    if (blArray[n3]) continue;
                    for (int j = 0; j < n4; ++j) {
                        this.sbs[n3].append("0");
                    }
                }
            }
        }
        for (n = 0; n < this.n; ++n) {
            stringArray[n] = this.sbs[n].toString();
        }
    }

    protected void getSequencesWithOutgroup(String[] stringArray, Node[] nodeArray, int n) {
        int n2;
        Object object;
        Object object2;
        int n3;
        boolean[] blArray = new boolean[this.n];
        for (n3 = 0; n3 < this.n + 1; ++n3) {
            this.sbs[n3] = new StringBuffer(10000);
        }
        for (n3 = 0; n3 < nodeArray.length; ++n3) {
            object2 = nodeArray[n3];
            this.ga.setGenealogy((Node)object2);
            object = this.ga.getNodes();
            for (n2 = 0; n2 < object.size(); ++n2) {
                int n4;
                Node node = (Node)object.get(n2);
                int n5 = node.getBranch().getMutation();
                if (n5 <= 0) continue;
                List list = this.ga.getLeavesOfDescendants(node);
                for (n4 = 0; n4 < this.n; ++n4) {
                    blArray[n4] = false;
                }
                for (n4 = 0; n4 < list.size(); ++n4) {
                    Node node2 = (Node)list.get(n4);
                    int n6 = node2.getNameID() - 1;
                    for (int i = 0; i < n5; ++i) {
                        this.sbs[n6].append("1");
                    }
                    blArray[n6] = true;
                }
                for (n4 = 0; n4 < this.n; ++n4) {
                    if (blArray[n4]) continue;
                    for (int i = 0; i < n5; ++i) {
                        this.sbs[n4].append("0");
                    }
                }
            }
        }
        for (n3 = 0; n3 < this.sbs[0].length(); ++n3) {
            this.sbs[this.n].append("0");
        }
        n3 = this.getNumOfInterMuts(n);
        object2 = "";
        object = "";
        for (n2 = 0; n2 < n3; ++n2) {
            object2 = (String)object2 + "0";
            object = (String)object + "1";
        }
        for (n2 = 0; n2 < this.n; ++n2) {
            this.sbs[n2].append((String)object2);
        }
        this.sbs[this.n].append((String)object);
        for (n2 = 0; n2 < this.n + 1; ++n2) {
            stringArray[n2] = this.sbs[n2].toString();
        }
    }

    protected int getK(Node[] nodeArray) {
        int n = 0;
        for (int i = 0; i < nodeArray.length; ++i) {
            this.ga.setGenealogy(nodeArray[i]);
            n += this.ga.getNumOfMutations();
        }
        return n;
    }

    protected int getK_minor(String[] stringArray, int[] nArray) {
        int n = 0;
        int n2 = stringArray[0].length();
        for (int i = 0; i < n2; ++i) {
            boolean bl;
            if (!this.isSegregating(stringArray, i) || (bl = this.isSegregatingInSubgroup(stringArray, i, nArray, false))) continue;
            ++n;
        }
        return n;
    }

    protected int getK_major(String[] stringArray, int[] nArray) {
        int n = this.getK(stringArray);
        int n2 = this.getK_minor(stringArray, nArray);
        return n - n2;
    }

    protected int getK(String[] stringArray) {
        int n = 0;
        int n2 = stringArray[0].length();
        for (int i = 0; i < n2; ++i) {
            if (!this.isSegregating(stringArray, i)) continue;
            ++n;
        }
        return n;
    }

    protected int getX(Node node) {
        int n = node.getChildAt(0).getSize();
        n = n > this.n / 2 ? this.n - n : n;
        return n;
    }

    protected Node getX_Node(Node node) {
        Node node2 = node.getChildAt(0);
        Node node3 = node.getChildAt(1);
        Node node4 = node2.getSize() < node3.getSize() ? node2 : node3;
        return node4;
    }

    protected int indexOf(int[] nArray, int n) {
        int n2 = -1;
        int n3 = nArray.length;
        for (int i = 0; i < n3; ++i) {
            if (nArray[i] != n) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    protected int indexOf(String[] stringArray, String string) {
        int n = -1;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    protected boolean isSegregating(String[] stringArray, int n) {
        boolean bl = false;
        char c = stringArray[0].charAt(n);
        for (int i = 1; i < stringArray.length; ++i) {
            if (c == stringArray[i].charAt(n)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected boolean isSegregatingInSubgroup(String[] stringArray, int n, int[] nArray, boolean bl) {
        boolean bl2 = false;
        char c = ' ';
        if (bl) {
            if (nArray.length > 0) {
                c = stringArray[nArray[0]].charAt(n);
            }
            int n2 = nArray.length;
            for (int i = 1; i < n2; ++i) {
                if (c == stringArray[nArray[i]].charAt(n)) continue;
                bl2 = true;
                break;
            }
        } else {
            int n3;
            int n4 = stringArray.length;
            int n5 = -1;
            for (n3 = 0; n3 < n4; ++n3) {
                if (this.indexOf(nArray, n3) != -1) continue;
                c = stringArray[n3].charAt(n);
                n5 = n3;
                break;
            }
            for (n3 = n5 + 1; n3 < n4; ++n3) {
                if (this.indexOf(nArray, n3) != -1 || c == stringArray[n3].charAt(n)) continue;
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    protected double logFactorial(int n) {
        return this.logFactorial[n];
    }

    protected int numOfNucDiff(String string, String string2) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) == string2.charAt(i)) continue;
            ++n;
        }
        return n;
    }

    protected void rootTree(Genealogy genealogy, String[] stringArray) {
        Node node = genealogy.getRoot();
        List list = this.ga.getLeavesOfDescendants(node);
        Node node2 = null;
        for (int i = 0; i < list.size(); ++i) {
            Node node3 = (Node)list.get(i);
            if (!node3.getName().equalsIgnoreCase(stringArray[this.n])) continue;
            node2 = node3;
            break;
        }
        TreeUtility.setRootAt(genealogy, node2, node2.getBranch().getLength() / 2.0);
    }

    protected void rootTree(Genealogy genealogy, String string) {
        Node node = genealogy.getRoot();
        List list = this.ga.getLeavesOfDescendants(node);
        Node node2 = null;
        for (int i = 0; i < list.size(); ++i) {
            Node node3 = (Node)list.get(i);
            if (!node3.getName().equalsIgnoreCase(string)) continue;
            node2 = node3;
            break;
        }
        TreeUtility.setRootAt(genealogy, node2, node2.getBranch().getLength() / 2.0);
    }

    protected double get_ai(int n, int n2, int[] nArray, int n3) {
        double d = Double.NaN;
        int n4 = n - n2;
        for (int i = 2; i <= n4; ++i) {
            if (nArray[i] > n3 || n3 >= nArray[i + 1]) continue;
            d = i;
            break;
        }
        if (d != this.get_ai_QuickVer(n, n2, nArray, n3)) {
            System.out.println("Error!!! ai != get_ai_QuickVer(n, x, es, i)!! Exit...");
            System.exit(0);
        }
        return d;
    }

    protected double get_ai_QuickVer(int n, int n2, int[] nArray, int n3) {
        double d = Double.NaN;
        int n4 = 2;
        int n5 = n - n2 + 1;
        return this.get_ai_QuickVer(nArray, n3, n4, n5);
    }

    protected double get_ai_QuickVer(int[] nArray, int n, int n2, int n3) {
        if (n2 == n3 - 1) {
            return n2;
        }
        int n4 = (n2 + n3) / 2;
        if (n < nArray[n4]) {
            return this.get_ai_QuickVer(nArray, n, n2, n4);
        }
        return this.get_ai_QuickVer(nArray, n, n4, n3);
    }

    protected double get_bi(int n, int n2, int[] nArray, int n3) {
        double d = Double.NaN;
        if (2 <= n3 && n3 < nArray[2]) {
            d = n3;
        } else {
            int n4 = n - n2;
            for (int i = 2; i <= n4; ++i) {
                if (nArray[i] > n3 || n3 >= nArray[i + 1]) continue;
                d = n3 - i;
                break;
            }
        }
        if (d != this.get_bi_QuickVer(n, n2, nArray, n3)) {
            System.out.println("Error!!! bi != get_bi_QuickVer(n, x, es, i)!! Exit...");
            System.exit(0);
        }
        return d;
    }

    protected double get_bi_QuickVer(int n, int n2, int[] nArray, int n3) {
        double d = Double.NaN;
        if (2 <= n3 && n3 < nArray[2]) {
            d = n3;
        } else {
            int n4 = 2;
            int n5 = n - n2 + 1;
            d = this.get_bi_QuickVer(nArray, n3, n4, n5);
        }
        return d;
    }

    protected double get_bi_QuickVer(int[] nArray, int n, int n2, int n3) {
        if (n2 == n3 - 1) {
            return n - n2;
        }
        int n4 = (n2 + n3) / 2;
        if (n < nArray[n4]) {
            return this.get_bi_QuickVer(nArray, n, n2, n4);
        }
        return this.get_bi_QuickVer(nArray, n, n4, n3);
    }
}

