/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;

public class Chromosome
implements Cloneable,
Serializable {
    private static BitSet RCsites = new BitSet();
    private static int numberRC = 0;
    private static int length = 1;
    private static int sampleSize = Integer.MAX_VALUE;
    private final int nSites = length;
    private BitSet segment = new BitSet(this.nSites);
    private int[] size;
    private Sequence sequence;
    private static SizePool pool = new SizePool();

    public Chromosome() {
        this.getSize();
        this.reset();
    }

    public int getSize(int n) {
        return this.size[n];
    }

    private int[] getSize() {
        if (this.size == null) {
            this.size = (int[])pool.borrow();
            for (int i = this.size.length - 1; i >= 0; --i) {
                this.size[i] = 1;
            }
        }
        return this.size;
    }

    public void releaseSize() {
        for (int i = Chromosome.length() - 1; i >= 0; --i) {
            this.size[i] = 0;
        }
        pool.release(this.size);
        this.size = null;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public int getLength() {
        return this.nSites;
    }

    public int nLinks() {
        return this.segment.length() - 1 - this.segment.nextSetBit(0);
    }

    public int firstLocus() {
        return this.segment.nextSetBit(0);
    }

    public int lastLocus() {
        return this.segment.length() - 1;
    }

    public double cardinalProportion() {
        return (double)this.segment.cardinality() / (double)Chromosome.length();
    }

    public int cardinality() {
        return this.segment.cardinality();
    }

    public int getActiveLoci(int n) {
        int n2 = -1;
        for (int i = n; i > 0; --i) {
            n2 = this.segment.nextSetBit(n2 + 1);
        }
        return n2;
    }

    public void reset() {
        this.segment.clear();
        this.segment.set(0, Chromosome.length());
        Arrays.fill(this.size, 1);
    }

    public void clear() {
        this.segment.clear();
    }

    public Object clone() {
        try {
            Chromosome chromosome = (Chromosome)super.clone();
            chromosome.segment = (BitSet)this.segment.clone();
            if (this.size != null) {
                chromosome.size = (int[])this.size.clone();
            }
            return chromosome;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void copyTo(Chromosome chromosome) {
        chromosome.segment.clear();
        chromosome.segment.or(this.segment);
        System.arraycopy(this.size, 0, chromosome.size, 0, this.size.length);
    }

    public static void resetRecombinationSites() {
        RCsites.clear(0, RCsites.size());
        numberRC = 0;
    }

    public static String recombinationSites() {
        int n = Chromosome.length();
        for (int i = 0; i < n; ++i) {
            System.out.print((RCsites.get(i) ? 1 : 0) + " ");
        }
        System.out.println(" RCsites=" + numberRC + " card=" + RCsites.cardinality());
        return null;
    }

    public String toString() {
        int n;
        int n2 = Math.max(this.getLength(), this.segment.length());
        for (n = 0; n < n2; ++n) {
            System.out.print((this.segment.get(n) ? 1 : 0) + " ");
        }
        System.out.println(" Length=" + this.getLength() + " Cardinal=" + this.cardinalProportion());
        n2 = Math.max(this.getLength(), this.segment.length());
        for (n = 0; n < n2; ++n) {
            System.out.print(this.size[n] + " ");
        }
        System.out.println(" Size");
        return null;
    }

    public static void setSampleSize(int n) {
        sampleSize = n;
    }

    public static void setLength(int n) {
        length = n;
    }

    public static int length() {
        return length;
    }

    public static BitSet getRCsites() {
        return (BitSet)RCsites.clone();
    }

    public static void breakAfterLocus(int n, Chromosome chromosome, Chromosome[] chromosomeArray) {
        for (int i = 0; i < 2; ++i) {
            chromosomeArray[i].segment.clear();
            chromosomeArray[i].segment.or(chromosome.segment);
            System.arraycopy(chromosome.size, 0, chromosomeArray[i].size, 0, Chromosome.length());
        }
        chromosomeArray[0].segment.clear(n + 1, Chromosome.length());
        Arrays.fill(chromosomeArray[0].size, n + 1, Chromosome.length(), 0);
        chromosomeArray[1].segment.clear(0, n + 1);
        Arrays.fill(chromosomeArray[1].size, 0, n + 1, 0);
        RCsites.set(n);
        ++numberRC;
    }

    public static void coalesce(Chromosome chromosome, Chromosome chromosome2, Chromosome chromosome3) {
        chromosome3.segment.clear();
        chromosome3.segment.or(chromosome.segment);
        chromosome3.segment.or(chromosome2.segment);
        for (int i = Chromosome.length() - 1; i >= 0; --i) {
            chromosome3.size[i] = chromosome.size[i] + chromosome2.size[i];
            if (chromosome3.size[i] != sampleSize) continue;
            chromosome3.segment.clear(i);
        }
    }

    private static class SizePool
    extends ObjectPoolAdapter {
        private SizePool() {
        }

        public Object construct() {
            return new int[Chromosome.length()];
        }
    }
}

